// Version/Precision tags are added programmatically on shader load

uniform vec4 uClipPlane;
uniform vec3 uLightAmb;
uniform vec3 uLightDif;
uniform vec3 uLightSky;
uniform vec4 uBaseColor;
uniform vec4 uFlagColor;

uniform sampler2D uTexture;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec3 P; // Position
varying vec2 UV; // UV

void main()
{
  /* Discard pixels behind Clipping Plane */
  float clipPos = dot(P, uClipPlane.xyz) + uClipPlane.w;
  if (clipPos < 0.0) {
    discard;
  }

  vec3 nN = normalize(N);
  
  // Flags are unlikely to ever need shadows
  
  float dotDirection = max(0.0, dot(nN, L));
  vec3 diffuse = dotDirection * uLightDif;

  float skyDirection = max(0.0, dot(nN, vec3(0, 0, 1)));
  vec3 sky = skyDirection * uLightSky;
  vec3 light = diffuse + uLightAmb + sky;

  vec4 tex = texture2D(uTexture, UV);

  // We know the pole from the flag by it's color. Flag has only Red component in LWO model. Pole is RGB mostly
  gl_FragColor.rgb = mix(uFlagColor.rgb, C.rgb, step(0.5, C.g)) * tex.rgb * light.rgb * uBaseColor.rgb;
  gl_FragColor.a = tex.a * uBaseColor.a * uFlagColor.a;
}